<?php
// api/get_settings.php
// پاسخ JSON سازگار با ESP32-CAM

header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../camera_settings_model.php';

$deviceId = isset($_GET['device_id']) ? trim($_GET['device_id']) : '';

if ($deviceId === '') {
    http_response_code(400);
    echo json_encode(['error' => 'device_id is required'], JSON_UNESCAPED_UNICODE);
    exit;
}

try {
    $pdo = getPDO();
    $settings = getCameraSettings($pdo, $deviceId);

    if ($settings === null) {
        http_response_code(404);
        echo json_encode(['error' => 'device not found'], JSON_UNESCAPED_UNICODE);
        exit;
    }

    // بازگردانی تنظیمات نهایی (مرج با پیش‌فرض‌ها)
    echo json_encode($settings, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['error' => 'database error'], JSON_UNESCAPED_UNICODE);
}
